       PROGRAM VRCMD
       
* Blame for this program resides with Peter A. Bergbusch, Dept. of Physics,
* University of Regina. 

* Last update: June 2, 2005.
       
* The INPUT FILE is in the format of a .iso file produced by VRISO
* PARAMETER NFP: A good choice is 250 fiducial points, similar to the 
*                number of points on the raw isochrones.
 
* COLOUR TRANSFORMATIONS and BOLOMETRIC CORRECTIONS      
* INPUT files bvrilo.data on unit 10 and bvrihi.data on unit 11 are opened
* and closed inside subroutine BVRI, and files uvbylo.data on unit 12 and 
* uvbyhi.data on unit 13 are opened and closed inside subroutine UVBY. 
* Copies of these files must be in the working directory.

*23456789012345678901234567890123456789012345678901234567890123456789012
       PARAMETER (NMX = 1000, NBN = 1000, NFP=250)
       IMPLICIT DOUBLE PRECISION (A-H,O-Z)
       DOUBLE PRECISION LUM(NMX),MASS(NMX),MBOL
       DIMENSION CSLUM(4,NMX),CSTEFF(4,NMX),CSMASS(4,NMX),
     1           TEFF(NMX),DTH(NMX)
       CHARACTER INFILE*60,OUTFILE*60,HLINE(7)*65,ALINE*11

       PARAMETER (C1 = 10.60917D0)

       CALL IOFILE(7,'IN','FILE.ISO',.FALSE.,' ',
     1               INFILE,.TRUE.,'Input ISOCHRONE File: ')
       CALL IOFILE(8,'OUT','FILE.CMD',.FALSE.,' ',
     1              OUTFILE,.TRUE.,'Output Fiducial File: ')
     
* Other INPUT files, BVRILO.DATA on unit 10 and BVRIHI.DATA on unit 11, 
* are opened and closed inside subroutine BVRI. UVBYLO.DATA on unit 12 and
* UVBYHI.DATA are opened and closed inside subroutine UVBY.

       DO J = 1, 7
         READ (7,'(A)') HLINE(J)
       END DO
       
       HLINE(1)(2:11)='Fiducials '
       WRITE(8,'(A)') HLINE(1)(1:14)
       DO J = 2, 7
         CALL STR_TRIM(65,HLINE(J),NCH)
         WRITE(8,'(A)') HLINE(J)(1:nch)
       END DO
       DO J = 2, 7
         CALL STR_TRIM(65,HLINE(J),NCH)
       END DO

       READ(HLINE(1),'(12x,I2)') NISO
       READ(HLINE(2),'(11X,F7.3)') FE

       WRITE(*,'(/,I6,'' ISOCHRONES'',t21,''[Fe/H] = '',f5.2)') 
     2        NISO,FE

       CALL BVRI(0,FE,G0,T0,BMV,VMR,VMI,BC)
       CALL UVBY(0,FE,G0,T0,SBY,SM1,SC1,BC)
                
*  Process one isochrone at a time

       DO NI = 1, NISO

         READ (7,'(/A)') ALINE
         READ (7,'(F6.2,I6)') AGE,NPTS
         WRITE(*,'(t15,'' Age, NPTS: '',F6.2,I6)') AGE,NPTS

*23456789012345678901234567890123456789012345678901234567890123456789012
         WRITE(8,'(/,A)') ALINE
         WRITE(8,'(F6.2,I5)') AGE,NFP

         DO NP = 1, NPTS

           READ(7,'(4X,F10.6,F9.6,F13.10,F11.7)') LUM(NP),
     1          TEFF(NP),MASS(NP),DTH(NP)         
         END DO
         
         DD = DTH(NPTS)/(NFP - 1)
         
         CALL AKM_CSPL (NPTS,DTH,LUM,CSLUM)
         CALL AKM_CSPL (NPTS,DTH,TEFF,CSTEFF)
         CALL AKM_CSPL (NPTS,DTH,MASS,CSMASS)
         
         WRITE(8,'(t12,a,t23,a,t31,A,t41,A,t50,A,6(5X,A))')
     1          'Mass','Mbol','log Te','log g','V/y','B-V','V-R',
     2          'V-I','b-y','m1',' c1'          
           
           DO J = 1, NFP
             IF (J.LT.NFP) THEN
               DFID = (J-1)*DD
             ELSE
               DFID = DTH(NPTS)
             END IF
             CALL AKM_EVAL (NPTS,DTH,CSLUM,DFID,FLUM,DFP)
             CALL AKM_EVAL (NPTS,DTH,CSTEFF,DFID,FTEFF,DFP)
             CALL AKM_EVAL (NPTS,DTH,CSMASS,DFID,FMASS,DFP)
             GRAV = LOG10(FMASS) - C1 + 4.0D0*FTEFF - FLUM
             CALL BVRI(1,FE,GRAV,FTEFF,BMV,VMR,VMI,BC)
             CALL UVBY(1,FE,GRAV,FTEFF,SBY,SM1,SC1,BC)
             MBOL = 4.75D0 - 2.5D0*FLUM
             V = MBOL - BC
             WRITE(8,'(I5,F14.10,F8.4,F10.6,8F8.4)') 
     1               J,FMASS,MBOL,FTEFF,GRAV,V,BMV,VMR,VMI,
     2                 SBY,SM1,SC1    
           END DO
         
       END DO
       
       CLOSE(UNIT=7,STATUS='KEEP')
       CLOSE(UNIT=8,STATUS='KEEP')

       STOP
       END
